import json
from collections import defaultdict
from collections import Counter
from wordcloud import WordCloud
import matplotlib.pyplot as plt



import pickle

with open('./Routinehub_shortcut2category.pkl', 'rb') as fp:
    shortcut2category = pickle.load(fp)

with open('./identifier2category.pkl', 'rb') as fp:
    identifier2category = pickle.load(fp)


with open('../../data/statistics.pkl', 'rb') as fp:
    statistics = pickle.load(fp)

category_to_apis = defaultdict(Counter)

for shortcut_name, shortcut_data in statistics.items():
    categories = shortcut2category.get(shortcut_name, [])
    if len(categories) == 0:
        continue

    action_names = shortcut_data.get('action_names', [])

    for category in categories:
        category_to_apis[category].update(action_names)

for category in category_to_apis.keys():
    # Generate the word cloud
    wordcloud = WordCloud(width=800, height=400, background_color='white').generate_from_frequencies(category_to_apis[category])

    # Display the word cloud
    plt.figure(figsize=(10, 5))
    plt.imshow(wordcloud, interpolation='bilinear')
    plt.axis('off')
    plt.show()

print('dada')